/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.test;

import com.eteks.sweethome3d.model.PieceOfFurniture;
import com.eteks.sweethome3d.plugin.Plugin;
import com.eteks.sweethome3d.plugin.PluginAction;
import javax.swing.JOptionPane;

public class VolumePlugin
extends Plugin {
    public PluginAction[] getActions() {
        return new PluginAction[]{new VolumeAction()};
    }

    public class VolumeAction
    extends PluginAction {
        public VolumeAction() {
            this.putPropertyValue(PluginAction.Property.NAME, "Compute volume");
            this.putPropertyValue(PluginAction.Property.MENU, "Tools");
            this.setEnabled(true);
        }

        public void execute() {
            float volumeInCm3 = 0.0f;
            for (PieceOfFurniture piece : VolumePlugin.this.getHome().getFurniture()) {
                if (!piece.isMovable()) continue;
                volumeInCm3 += piece.getWidth() * piece.getDepth() * piece.getHeight();
            }
            String message = String.format("The maximum volume of the movable furniture in home is %.2f m\u00b3.", Float.valueOf(volumeInCm3 / 1000000.0f));
            JOptionPane.showMessageDialog(null, message);
        }
    }
}

